// ShadowFlare's SFmpq API interface for Delphi
// Interface written by DooMeeR
//
//   actually I have only tested these functions:
//
//   SFMpqGetVersionString
//
//   SFileOpenArchive
//   SFileCloseArchive
//   SFileOpenFileEx
//   SFileCloseFile
//   SFileReadFile - working but crashes the program :(
//   SFileGetFileSize
//
//   MpqOpenArchiveForUpdate
//   MpqCloseUpdatedArchive
//   MpqAddFileToArchive
//   MpqRenameFile
//   MpqDeleteFile
//
//   and these flags:
//
//   MOAU_OPEN_ALWAYS
//   MAFA_REPLACE_EXISTING
//   MAFA_COMPRESS
//
//   Exemple: How to add a file to an archive? How to add it compressed?
//
//     var H: THandle;
//     begin
//       H:=MpqOpenArchiveForUpdate('filename.mpq', MOAU_OPEN_ALWAYS, 100); // Not sure about the third parameter
//       // To add it normally:
//       if not MpqAddFileToArchive(H, 'externalfiletoadd.ext', 'internalname.ext', MAFA_REPLACE_EXISTING or MAFA_COMPRESS) then showmessage('Error.');
//       // To add it compressed:
//       if not MpqAddFileToArchive(H, 'externalfiletoadd.ext', 'internalname.ext', MAFA_REPLACE_EXISTING) then showmessage('Error.');
//       MpqCloseUpdatedArchive(H, 0);
//     end;
//
// Comments: d@doomeer.com (http://www.doomeer.com)
unit sfmpq;

interface

uses Windows;

const SFMPQ_DLL = 'SFmpq.dll';

const // MpqOpenArchiveForUpdate flags
      MOAU_CREATE_NEW        = $00;
      MOAU_CREATE_ALWAYS     = $08; // Was wrongly named MOAU_CREATE_NEW
      MOAU_OPEN_EXISTING     = $04;
      MOAU_OPEN_ALWAYS       = $20;
      MOAU_READ_ONLY         = $10; // Must be used with MOAU_OPEN_EXISTING
      MOAU_MAINTAIN_LISTFILE = $01;

      // MpqAddFileToArchive flags
      MAFA_EXISTS           = $80000000; // Will be added if not present
      MAFA_UNKNOWN40000000  = $40000000;
      MAFA_MODCRYPTKEY      = $00020000;
      MAFA_ENCRYPT          = $00010000;
      MAFA_COMPRESS         = $00000200;
      MAFA_COMPRESS2        = $00000100;
      MAFA_REPLACE_EXISTING = $00000001;

      // MpqAddFileToArchiveEx compression flags
      MAFA_COMPRESS_STANDARD = $08; // Standard PKWare DCL compression
      MAFA_COMPRESS_DEFLATE  = $02; // ZLib's deflate compression
      MAFA_COMPRESS_WAVE     = $81; // Standard wave compression
      MAFA_COMPRESS_WAVE2    = $41; // Unused wave compression

function SFMpqGetVersionString: LPCSTR; stdcall; external SFMPQ_DLL;

// Storm functions implemented by this library
function SFileOpenArchive(lpFileName: LPCSTR; dwMPQID: DWORD; dwUnknown: DWORD; var lphMPQ: THANDLE): boolean; stdcall; external SFMPQ_DLL;
function SFileCloseArchive(hMPQ: THANDLE): boolean; stdcall; external SFMPQ_DLL;
function SFileOpenFileEx(hMPQ: THANDLE; lpFileName: LPCSTR; dwSearchScope: DWORD; var lphFile: THANDLE): boolean; stdcall; external SFMPQ_DLL;
function SFileCloseFile(hFile: THANDLE): boolean; stdcall; external SFMPQ_DLL;
//function SFileReadFile(hFile: THANDLE; lpBuffer: Pointer; nNumberOfBytesToRead: DWORD; lpNumberOfBytesRead: LPDWORD; lpOverlapped: Pointer): boolean; stdcall; external SFMPQ_DLL;
function SFileReadFile(HFILE : integer; var buf; size,p4,p5 : integer) : boolean; stdcall; external 'SFmpq.dll' index $010D;
function SFileGetFileSize(hFile: THANDLE; lpFileSizeHigh: LPDWORD): DWORD; stdcall; external SFMPQ_DLL;

// Archive editing functions implemented by this library
function MpqOpenArchiveForUpdate(lpFileName: LPCSTR; dwFlags: DWORD; dwMaximumFilesInArchive: DWORD): THANDLE; stdcall; external SFMPQ_DLL;
function MpqCloseUpdatedArchive(hMPQ: THANDLE; dwUnknown2: DWORD): DWORD; stdcall; external SFMPQ_DLL;
function MpqAddFileToArchive(hMPQ: THANDLE; lpSourceFileName: LPCSTR; lpDestFileName: LPCSTR; dwFlags: DWORD): boolean; stdcall; external SFMPQ_DLL;
function MpqAddWaveToArchive(hMPQ: THANDLE; lpSourceFileName: LPCSTR; lpDestFileName: LPCSTR; dwFlags: DWORD; dwQuality: DWORD): boolean; stdcall; external SFMPQ_DLL;
function MpqRenameFile(hMPQ: THANDLE; lpcOldFileName: LPCSTR; lpcNewFileName: LPCSTR): boolean; stdcall; external SFMPQ_DLL;
function MpqDeleteFile(hMPQ: THANDLE; lpFileName: LPCSTR): boolean; stdcall; external SFMPQ_DLL;
function MpqCompactArchive(hMPQ: THANDLE): boolean; stdcall; external SFMPQ_DLL;

// Extra archive editing functions
function MpqAddFileToArchiveEx(hMPQ: THANDLE; lpSourceFileName: LPCSTR; lpDestFileName: LPCSTR; dwFlags: DWORD; dwCompressionType: DWORD; dwCompressLevel: DWORD): boolean; stdcall; external SFMPQ_DLL;
function MpqAddFileFromBufferEx(hMPQ: THANDLE; lpBuffer: Pointer; dwLength: DWORD; lpFileName: LPCSTR; dwFlags: DWORD; dwCompressionType: DWORD; dwCompressLevel: DWORD): boolean; stdcall; external SFMPQ_DLL;
function MpqAddFileFromBuffer(hMPQ: THANDLE; lpBuffer: Pointer; dwLength: DWORD; lpFileName: LPCSTR; dwFlags: DWORD): boolean; stdcall; external SFMPQ_DLL;
function MpqAddWaveFromBuffer(hMPQ: THANDLE; lpBuffer: Pointer; dwLength: DWORD; lpFileName: LPCSTR; dwFlags: DWORD; dwQuality: DWORD): boolean; stdcall; external SFMPQ_DLL;
function MpqSetFileLocale(hMPQ: THANDLE; lpFileName: LPCSTR; nOldLocale: LCID; nNewLocale: LCID): boolean; stdcall; external SFMPQ_DLL;

implementation

end.
