unit randoms;

interface

uses Math, Dialogs, SysUtils{, RomUnit};

type TSloc = record
       X, Y: integer;
     end;
     TSlocList = array of TSloc;

// MinLen: minimum distance between each players
// MapPlayable(W/H): playable width and height
// Not: it assumes the point (0, 0) is at the center of the map
function RandomSloc(NbPlayers: byte; MinLen: integer; MinFromCenter: integer; MapPlayableW, MapPlayableH: integer): TSlocList;
function RandomStartMine(PlayerX, PlayerY: integer; MapW, MapH: integer): TSloc;

implementation

function RandomSloc(NbPlayers: byte; MinLen: integer; MinFromCenter: integer; MapPlayableW, MapPlayableH: integer): TSlocList;
var i, n, cnt: integer;
    b: boolean;
begin
  SetLength(result, NbPlayers);

  b:=true;
  cnt:=0;
  while b and (cnt<10000) do // Maximum number of tries: 10000
  begin
    inc(cnt);

    // Chose random start locations
    for i:=0 to NbPlayers-1 do
    begin
      result[i].X:=random(MapPlayableW)-(MapPlayableW div 2);
      result[i].Y:=random(MapPlayableH)-(MapPlayableH div 2);
    end;

    // Test if the locations are ok
    b:=false;
    for i:=0 to NbPlayers-1 do
    begin
      if Hypot(result[i].X, result[i].Y)<MinFromCenter then
      begin
        b:=true;
        break;
      end;
      for n:=0 to NbPlayers-1 do
      begin
        if i<>n then
          if Hypot(result[i].X-result[n].X, result[i].Y-result[n].Y)<MinLen then
          begin
            b:=true;
            break;
          end;
      end;
    end;
  end;

  if cnt>=10000 then SetLength(result, 0);

  // Now we multiply by 128
  for i:=0 to Length(result)-1 do
  begin
    result[i].X:=result[i].X*128;
    result[i].Y:=result[i].Y*128;
  end;
end;

function RandomStartMine(PlayerX, PlayerY: integer; MapW, MapH: integer): TSloc;
var r: integer;
    AddX, AddY, LimX, LimY: integer;
begin
  r:=random(8);
  case r of
    0: begin AddX:=+64*12; AddY:=0; end;
    1: begin AddX:=-64*12; AddY:=0; end;
    2: begin AddX:=0; AddY:=+64*12; end;
    3: begin AddX:=0; AddY:=-64*12; end;
    4: begin AddX:=+64*9; AddY:=+64*9; end;
    5: begin AddX:=+64*9; AddY:=-64*9; end;
    6: begin AddX:=-64*9; AddY:=+64*9; end;
    else begin AddX:=-64*9; AddY:=-64*9; end;
  end;

  {Debug(['-------- Mine --------']);
  Debug(['PlayerX = ', PlayerX]);
  Debug(['PlayerY = ', PlayerY]);
  Debug(['24*128 = ', 24*128]);
  Debug(['(MapW-24)*128 = ', (MapW-24)*128]);
  Debug(['(MapH-24)*128 = ', (MapH-24)*128]);}
  LimX:=((MapW div 2)-24)*128;
  LimY:=((MapH div 2)-24)*128;
  if PlayerX<-LimX then AddX:=abs(AddX);
  if PlayerX>LimX then AddX:=-abs(AddX);
  if PlayerY<-LimY then AddY:=abs(AddY);
  if PlayerY>LimY then AddY:=-abs(AddY);

  result.X:=PlayerX+AddX;
  result.Y:=PlayerY+AddY;
end;

end.
