{$A+,B-,C+,D+,E-,F-,G+,H+,I+,J-,K-,L+,M-,N+,O+,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y+,Z1}
{$MINSTACKSIZE $00004000}
{$MAXSTACKSIZE $00100000}
{$IMAGEBASE $00400000}
{$APPTYPE GUI}
unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, sfmpq, W3files, ExtCtrls, Lissage, randoms, Math, RomUnit;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Version: TButton;
    MPQMODE: TButton;
    Generer: TButton;
    Button2: TButton;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Panel1: TPanel;
    Image1: TImage;
    Button6: TButton;
    Button7: TButton;
    procedure Button1Click(Sender: TObject);
    procedure VersionClick(Sender: TObject);
    procedure MPQMODEClick(Sender: TObject);
    procedure GenererClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
  private
    { Dclarations prives }
  public
    P1, P2, P3, P4, P5, P6: TLPoint;
    procedure Parabol;
    procedure ParabolPath;
  end;

var
  Form1: TForm1;


implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var H, FH: THANDLE;
    Size: DWORD;
    Buff: array[1..2048] of char;
    r: LPDWORD;
    Mem: TMemoryStream;
begin
  //if not MpqInitialize then showmessage('Erreur dans MpqInitialize');
  if not SFileOpenArchive('test.w3m', 0, 0, H) then showmessage('Erreur dans SFileOpenArchive');
  if not SFileOpenFileEx(H, 'war3map.w3e', 0, FH) then showmessage('Erreur dans SFileOpenFileEx');

  Size:=SFileGetFileSize(FH, nil);
  Caption:=(inttostr(Size));

  new(r);
  if not SFileReadFile(FH, Buff, 2048, 0, 0) then showmessage('Erreur dans SFileReadFile');
  //showmessage(inttostr(r^));
  dispose(r);
  Mem:=TMemoryStream.Create;
  Mem.Write(Buff, 2048);
  Mem.SaveToFile('test.plop');
  Mem.Free;

  if not SFileCloseFile(FH) then showmessage('Erreur dans SFileCloseFile');
  if not SFileCloseArchive(H) then showmessage('Erreur dans SFileCloseArchive');

end;

procedure TForm1.VersionClick(Sender: TObject);
begin
//  Version.Caption:=SFMpqGetVersionString;
end;

procedure TForm1.MPQMODEClick(Sender: TObject);
var H: THandle;
begin
  H:=MpqOpenArchiveForUpdate('plop.w3m', MOAU_OPEN_ALWAYS, 100);
// if not MpqDeleteFile(H, 'war3map.w3e') then showmessage('erreur dans delete');
  if not MpqAddFileToArchive(H, 'test.plop', 'war3map.w3e', MAFA_REPLACE_EXISTING or MAFA_COMPRESS) then showmessage('erreur dans addfile');
  MpqCloseUpdatedArchive(H, 0);
end;

procedure TForm1.GenererClick(Sender: TObject);
var w3e: TMap_w3e;
    x, y: integer;
    PTP: ^TTilePoint;
    F: TFileStream;
begin
  w3e:=TMap_w3e.Create;
  w3e.MapWidth:=64;
  w3e.MapHeight:=64;
  w3e.Main_Tileset:=TS_Lordaeron_Summer;
  w3e.TileSet.Add(LSTILE_DIRT);
  for x:=0 to 64 do
    for y:=0 to 64 do
    begin
      PTP:=@w3e.Map[y, x];
      PTP^.GroundHeight:=$2000;
      PTP^.WaterLevel:=0;
      PTP^.Boundary1:=false;
      PTP^.Ramp:=false;
      PTP^.Blight:=false;
      PTP^.Water:=false;
      PTP^.Boundary2:=false;
      if random(100)>80 then PTP^.TextureDetails:=random(16) else PTP^.TextureDetails:=random(4)*4;
      PTP^.GroundTile:=0;
      PTP^.CliffTexture:=0;
      PTP^.LayerHeight:=2;
    end;
  for x:=0 to 5 do
    for y:=0 to 64 do
      w3e.Map[y, x].Boundary1:=true;
  for x:=58 to 64 do
    for y:=0 to 64 do
      w3e.Map[y, x].Boundary1:=true;
  for y:=0 to 8 do
    for x:=0 to 64 do
      w3e.Map[y, x].Boundary1:=true;
  for y:=61 to 64 do
    for x:=0 to 64 do
      w3e.Map[y, x].Boundary1:=true;
  F:=TFileStream.Create('test.w3e', fmCreate or fmShareExclusive);
  w3e.SaveToStream(F);
  F.Free;
  w3e.Free;
end;

procedure TForm1.Button2Click(Sender: TObject);
var H: THandle;
begin
  H:=MpqOpenArchiveForUpdate('test.w3m', MOAU_OPEN_ALWAYS, 100);
  if not MpqAddFileToArchive(H, 'test.w3e', 'war3map.w3e', MAFA_REPLACE_EXISTING) then showmessage('erreur dans addfile (e)');
  if not MpqAddFileToArchive(H, 'test.w3i', 'war3map.w3i', MAFA_REPLACE_EXISTING) then showmessage('erreur dans addfile (i)');
  MpqCloseUpdatedArchive(H, 0);
end;

procedure TForm1.Edit1Change(Sender: TObject);
var f: single;
    M: TMemoryStream;
    c: cardinal;
begin
  c:=strtointdef(Edit1.Text, 0);
  M:=TMemoryStream.Create;
  M.Write(c, 4);
  M.Position:=0;
  M.Read(f, 4);
  M.Free;
  Label2.Caption:=floattostr(f);
end;

procedure TForm1.Button3Click(Sender: TObject);
var w3i: TMap_w3i;
    F: TFileStream;
    i: integer;
begin
  w3i:=TMap_w3i.Create;
  SetLength(w3i.Players, 2);
  for i:=0 to 1 do
  begin
    new(w3i.Players[i]);
    with w3i.Players[i]^ do
    begin
      FixedPosition:=false;
      StartingX:=random(48*128)-24*128;
      StartingY:=random(48*128)-24*128;
      LowPriorFlags:=0;
      HighPriorFlags:=0;
    end;
  end;
  w3i.NbForces:=1;
  w3i.Main_Tileset:=TS_Lordaeron_Summer;
  F:=TFileStream.Create('test.w3i', fmCreate or fmShareExclusive);
  w3i.SaveToStream(F);
  F.Free;
  w3i.Free;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  randomize;
end;

type TGTInfos = record
       Texture: byte;
       Map: TMap_w3e;
       MinSize, MaxSize: byte;
     end;

procedure PutGroundTexture(X, Y: single; Data: Pointer);
var iX, iY, Size, i, n: integer;
begin
  iX:=round(X);
  iY:=round(Y);
  with TGTInfos(Data^) do
  begin
    Size:=random(MaxSize-MinSize+1)+MinSize;
    for i:=-Size div 2 to Size div 2 do
    begin
      for n:=-Size div 2 to Size div 2 do
      begin
        if not ((iX+i>=Map.MapWidth-1) or (iX+i<=0) or (iY+n>=Map.MapHeight-1) or (iY+n<=0)) then
        begin
          //Debug([i, ', ', n, '? ', Size]);
          if Hypot(i, n)<=Size div 2 then
          begin
            //Debug([i, ', ', n, ': ', Hypot(i, n)]);
            Map.Map[iX+i, iY+n].GroundTile:=Texture;
          end;
        end;
      end;
    end;
  end;
end;

function RandomPoint(MinX, MinY, MaxX, MaxY: integer): TLPoint;
begin
  result.X:=random(MaxX-MinX)+MinX;
  result.Y:=random(MaxY-MinY)+MinY;
end;

procedure TForm1.Button4Click(Sender: TObject);
var Map: Tw3Map;
    i, x, y: integer;
    PTP: ^TTilePoint;
    H: THandle;
    Curve1, Curve2: TRandomCurve;
    Slocs: TSlocList;
    P: TSloc;
    Path: TCallPath;
    GTInfos: TGTInfos;
begin
  Map:=Tw3Map.Create(64, 64);
  Map.Main_Tileset:=TS_Lordaeron_Summer;
  Slocs:=RandomSloc(4, 24, 64 div 4, 64-16-4, 64-16-4);
  if Length(Slocs)=0 then begin ShowMessage('Erreur bizarre.'); exit; end;
  for i:=0 to 3 do
  begin
    with Map.AddPlayer^ do
    begin
      // Start location
      FixedPosition:=false;
      StartingX:=Slocs[i].X;
      StartingY:=Slocs[i].Y;
      LowPriorFlags:=0;
      HighPriorFlags:=0;

      // Mine
      P:=RandomStartMine(round(StartingX), round(StartingY), 64, 64);
      Map.AddGoldMine(P.X, P.Y, 12500);
    end;
  end;

  Curve1:=TRandomCurve.Create;
  Curve1.Randomize(16, 65, 0000, 1000);
  Curve2:=TRandomCurve.Create;
  Curve2.Randomize(16, 65, 0000, 1000);
  Map.w3e.TileSet.Add(LSTILE_DIRT);
  Map.w3e.TileSet.Add(LSTILE_ROUGH_DIRT);
  Map.w3e.TileSet.Add(LSTILE_GRASSY_DIRT);
  Map.w3e.TileSet.Add(LSTILE_ROCK);
  Map.w3e.TileSet.Add(LSTILE_GRASS);
  Map.w3e.TileSet.Add(LSTILE_DARK_GRASS);
  for x:=0 to 64 do
    for y:=0 to 64 do
    begin
      PTP:=@Map.w3e.Map[y, x];
      PTP^.GroundHeight:=$2000;
      PTP^.GroundHeight:=$2000+Curve1.Heights[x]+Curve2.Heights[y]+random(100);
      PTP^.WaterLevel:=0;
      PTP^.Boundary1:=false;
      PTP^.Ramp:=false;
      PTP^.Blight:=false;
      PTP^.Water:=false;
      PTP^.Boundary2:=false;
      if random(100)>80 then PTP^.TextureDetails:=random(16) else PTP^.TextureDetails:=random(4)*4;
      PTP^.GroundTile:=0;
      PTP^.CliffTexture:=0;
      PTP^.LayerHeight:=2;
    end;
  Curve1.Free;
  Curve2.Free;
  for x:=0 to 5 do
    for y:=0 to 64 do
      Map.w3e.Map[y, x].Boundary1:=true;
  for x:=58 to 64 do
    for y:=0 to 64 do
      Map.w3e.Map[y, x].Boundary1:=true;
  for y:=0 to 8 do
    for x:=0 to 64 do
      Map.w3e.Map[y, x].Boundary1:=true;
  for y:=61 to 64 do
    for x:=0 to 64 do
      Map.w3e.Map[y, x].Boundary1:=true;

  for i:=1 to 16 do
  begin
    Path:=TCallPath.Create(RandomPoint(0, 0, 65, 65), RandomPoint(0, 0, 65, 65), RandomPoint(0, 0, 65, 65), RandomPoint(0, 0, 65, 65));
    x:=random(100);
    if x<10 then GTInfos.Texture:=0 else
    if x<30 then GTInfos.Texture:=1 else
    if x<40 then GTInfos.Texture:=2 else
    if x<40 then GTInfos.Texture:=3 else
    if x<70 then GTInfos.Texture:=4 else
      GTInfos.Texture:=5;
    GTInfos.Map:=Map.w3e;
    GTInfos.MinSize:=2;
    GTInfos.MaxSize:=6;
    Path.Run(0, 1, 1/20, PutGroundTexture, @GTInfos);
    Path.Free;
  end;

  Map.w3i.NbForces:=1;

  for i:=1 to 30 do
    Map.SetTree(random(64), random(64), true);

  for x:=0 to 63 do
    for y:=0 to 63 do
      if Map.CanAddDoodad(x, y) then Map.w3e.Map[Y, X].GroundTile:=3;

  if not DirectoryExists('temp') then
    CreateDir('temp');
  Map.GenerateFiles('temp');

  CopyFile('temp\basetest.w3m', 'temp\test.w3m', false);

  if FileExists('temp\test.w3m') then
  begin
    H:=MpqOpenArchiveForUpdate('temp\test.w3m', MOAU_OPEN_ALWAYS, 100);
    if not MpqAddFileToArchive(H, 'temp\war3map.w3e', 'war3map.w3e', MAFA_REPLACE_EXISTING) then showmessage('erreur dans addfile (w3e)');
    if not MpqAddFileToArchive(H, 'temp\war3map.w3i', 'war3map.w3i', MAFA_REPLACE_EXISTING) then showmessage('erreur dans addfile (w3i)');
    if not MpqAddFileToArchive(H, 'temp\war3map.wts', 'war3map.wts', MAFA_REPLACE_EXISTING) then showmessage('erreur dans addfile (wts)');
    if not MpqAddFileToArchive(H, 'temp\war3mapUnits.doo', 'war3mapUnits.doo', MAFA_REPLACE_EXISTING) then showmessage('erreur dans addfile (Units.doo)');
    if not MpqAddFileToArchive(H, 'temp\war3map.doo', 'war3map.doo', MAFA_REPLACE_EXISTING) then showmessage('erreur dans addfile (doo)');
    MpqCloseUpdatedArchive(H, 0);
  end;

  SetLength(Slocs, 0);
  Map.Free;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  Image1.Tag:=0;
end;

procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  case Image1.Tag of
    0: begin P1.X:=X; P1.Y:=Y; end;
    1: begin P2.X:=X; P2.Y:=Y; end;
    2: begin P3.X:=X; P3.Y:=Y; end;
    3: begin P4.X:=X; P4.Y:=Y; end;
    4: begin P5.X:=X; P5.Y:=Y; end;
    5: begin P6.X:=X; P6.Y:=Y; Parabol; Image1.Tag:=-1; end;
    10: begin P1.X:=X; P1.Y:=Y; end;
    11: begin P2.X:=X; P2.Y:=Y; end;
    12: begin P3.X:=X; P3.Y:=Y; end;
    13: begin P4.X:=X; P4.Y:=Y; ParabolPath; Image1.Tag:=9; end;
  end;
  Image1.Tag:=Image1.Tag+1;
end;

procedure TForm1.Parabol;
var C, CC: TD2CList;
    P, PP: TLPList;
    i: integer;
    Bmp: TBitmap;
begin
  SetLength(P, 6);
  P[0]:=P1; P[1]:=P2; P[2]:=P3; P[3]:=P4; P[4]:=P5; P[5]:=P6;
  C:=GetCoeffList(P);

  PP:=GetSmoothCurvePoints(C, P);
  CC:=GetCoeffList(PP);

  Bmp:=TBitmap.Create;
  Bmp.Width:=Image1.Width;
  Bmp.Height:=Image1.Height;
  with Bmp.Canvas do
  begin
    Pen.Color:=clBlack;
    Pen.Style:=psSolid;
    Brush.Color:=clWhite;
    Brush.Style:=bsSolid;
    FillRect(Rect(0, 0, Image1.Width, Image1.Height));

    MoveTo(0, round(GetCurveY(CC, PP, 0)));
    for i:=1 to 100 do
    begin
      LineTo(round(i*Image1.Width/100), round(GetCurveY(CC, PP, 0, Image1.Width, i/100)));
    end;

    Ellipse(round(P1.X)-4, round(P1.Y)-4, round(P1.X)+4, round(P1.Y)+4);
    Ellipse(round(P2.X)-4, round(P2.Y)-4, round(P2.X)+4, round(P2.Y)+4);
    Ellipse(round(P3.X)-4, round(P3.Y)-4, round(P3.X)+4, round(P3.Y)+4);
    Ellipse(round(P4.X)-4, round(P4.Y)-4, round(P4.X)+4, round(P4.Y)+4);
    Ellipse(round(P5.X)-4, round(P5.Y)-4, round(P5.X)+4, round(P5.Y)+4);
    Ellipse(round(P6.X)-4, round(P6.Y)-4, round(P6.X)+4, round(P6.Y)+4);
  end;
  Image1.Canvas.Draw(0, 0, Bmp);
  Bmp.Free;

  SetLength(C, 0);
  SetLength(CC, 0);
  SetLength(P, 0);
  SetLength(PP, 0);
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  P1.X:=0;
  P2.X:=Image1.Width/5;
  P3.X:=2*Image1.Width/5;
  P4.X:=3*Image1.Width/5;
  P5.X:=4*Image1.Width/5;
  P6.X:=Image1.Width;
  P1.Y:=random(Image1.Height div 2)+Image1.Height/4;
  P2.Y:=random(Image1.Height div 2)+Image1.Height/4;
  P3.Y:=random(Image1.Height div 2)+Image1.Height/4;
  P4.Y:=random(Image1.Height div 2)+Image1.Height/4;
  P5.Y:=random(Image1.Height div 2)+Image1.Height/4;
  P6.Y:=random(Image1.Height div 2)+Image1.Height/4;
  {P1.Y:=Image1.Height/2;
  P2.Y:=P1.Y+random(Image1.Height div 4)-Image1.Height/8;
  P3.Y:=P2.Y+random(Image1.Height div 4)-Image1.Height/8;
  P4.Y:=P3.Y+random(Image1.Height div 4)-Image1.Height/8;
  P5.Y:=P4.Y+random(Image1.Height div 4)-Image1.Height/8;
  P6.Y:=P5.Y+random(Image1.Height div 4)-Image1.Height/8;}
  Parabol;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  Image1.Tag:=10;
end;

procedure PathProc(X, Y: single; Data: Pointer);
begin
  TBitmap(Data).Canvas.LineTo(round(X), round(Y));
end;

procedure TForm1.ParabolPath;
var Path: TCallPath;
    Bmp: TBitmap;
begin
  Path:=TCallPath.Create(P1, P2, P3, P4);

  Bmp:=TBitmap.Create;
  Bmp.Width:=Image1.Width;
  Bmp.Height:=Image1.Height;
  with Bmp.Canvas do
  begin
    Pen.Color:=clBlack;
    Pen.Style:=psSolid;
    Brush.Color:=clWhite;
    Brush.Style:=bsSolid;
    FillRect(Rect(0, 0, Image1.Width, Image1.Height));

    MoveTo(round(P1.X), round(P1.Y));
    Path.Run(0, 1, 1/20, PathProc, Bmp);

    Ellipse(round(P1.X)-4, round(P1.Y)-4, round(P1.X)+4, round(P1.Y)+4);
    Ellipse(round(P2.X)-4, round(P2.Y)-4, round(P2.X)+4, round(P2.Y)+4);
    Ellipse(round(P3.X)-4, round(P3.Y)-4, round(P3.X)+4, round(P3.Y)+4);
    Ellipse(round(P4.X)-4, round(P4.Y)-4, round(P4.X)+4, round(P4.Y)+4);
  end;
  Image1.Canvas.Draw(0, 0, Bmp);
  Bmp.Free;

  Path.Free;
end;

end.
