let comps = [
  `Velo; `Karate; `Epees; `Course;
  `Flute; `Pipeau; `Percussion; `Triangle;
  `BouleDeFeu; `ArmureDeGlace; `Eclair; `Teleportation]

let caracs = [
  `Force; `Dexterite; `Endurance; `Vitesse; `Magie; `Charisme]

let string_of_c = function
(* comps *)
| `Velo -> "Vélo (corps)"
| `Karate -> "Karaté (corps)"
| `Epees -> "Epées (corps)"
| `Course -> "Course (corps)"
| `Flute -> "Flûte (musique)"
| `Pipeau -> "Pipeau (musique)"
| `Percussion -> "Percussion (musique)"
| `Triangle -> "Triangle (musique)"
| `BouleDeFeu -> "Boule de feu (magie)"
| `ArmureDeGlace -> "Armure de glace (magie)"
| `Eclair -> "Eclair (magie)"
| `Teleportation -> "Téléportation (magie)"
(* caracs *)
| `Force -> "Force"
| `Dexterite -> "Dextérité"
| `Endurance -> "Endurance"
| `Vitesse -> "Vitesse"
| `Magie -> "Magie"
| `Charisme -> "Charisme"

let compliens = function
(* lignée corporelle *)
(* lignée musicale *)
(* lignée magique *)
  `Velo -> [
    `Force, 3;
    `Dexterite, 1;
    `Endurance, 5;
    `Vitesse, 2;
    `Magie, -8;
    `Charisme, -1]
| `Karate -> [
    `Force, 3;
    `Dexterite, 2;
    `Endurance, 3;
    `Vitesse, 2;
    `Magie, -9;
    `Charisme, -1]
| `Epees -> [
    `Force, 4;
    `Dexterite, 3;
    `Endurance, 2;
    `Vitesse, 1;
    `Magie, -9;
    `Charisme, -1]
| `Course -> [
    `Force, 0;
    `Dexterite, -1;
    `Endurance, 5;
    `Vitesse, 5;
    `Magie, -8;
    `Charisme, -1]
| `Flute -> [
    `Force, -7;
    `Dexterite, 5;
    `Endurance, 0;
    `Vitesse, -3;
    `Magie, 0;
    `Charisme, 5]
| `Pipeau -> [
    `Force, -8;
    `Dexterite, 4;
    `Endurance, 0;
    `Vitesse, -2;
    `Magie, 0;
    `Charisme, 6]
| `Percussion -> [
    `Force, 1;
    `Dexterite, 3;
    `Endurance, 0;
    `Vitesse, 3;
    `Magie, -10;
    `Charisme, 3]
| `Triangle -> [
    `Force, 1;
    `Dexterite, 1;
    `Endurance, -2;
    `Vitesse, 0;
    `Magie, -8;
    `Charisme, 8]
| `BouleDeFeu -> [
    `Force, -3;
    `Dexterite, -3;
    `Endurance, -3;
    `Vitesse, -1;
    `Magie, 10;
    `Charisme, 0]
| `ArmureDeGlace -> [
    `Force, -2;
    `Dexterite, -4;
    `Endurance, -2;
    `Vitesse, -2;
    `Magie, 9;
    `Charisme, 1]
| `Eclair -> [
    `Force, -6;
    `Dexterite, -2;
    `Endurance, -2;
    `Vitesse, 1;
    `Magie, 8;
    `Charisme, 1]
| `Teleportation -> [
    `Force, -5;
    `Dexterite, -5;
    `Endurance, 0;
    `Vitesse, 3;
    `Magie, 7;
    `Charisme, 0]
| _ -> failwith "Not a competence"

(************************************************************)

let (@@) perso c =
  let _, v = List.find (fun (c', _) -> c' = c) perso in v

let (@!) p c = !(p@@c)

(************************************************************)

let new_perso () =
  List.map (fun c -> c, ref 0) (comps@caracs)

let apprend perso c =
  let cl = compliens c in
  perso@@c := (perso@!c) + 1;
  List.iter (fun (c, v) ->
    perso@@c := (perso@!c) + v(*;
    if perso@!c < 0 then perso@@c := 0*)) cl

let efficacite perso c =
  let cl = compliens c in
  let cs = List.fold_left (fun s (c, v) ->
    if v > 0 then s + (perso@!c) * v else s) 0 cl in
  let sqrs = List.fold_left (fun s (c, v) ->
    if v > 0 then s + v * v else s) 0 cl in
    int_of_float(sqrt((float_of_int cs) /. (float_of_int sqrs) *. (float_of_int (perso@!c))))

let synergie_globale perso =
  let cs = List.fold_left (fun s c -> s + (perso@!c)) 0 comps in
  let es = List.fold_left (fun s c -> s + (efficacite perso c)) 0 comps in
    (float_of_int es) /. (float_of_int cs)

(************************************************************)

let perso = new_perso ()

let delete_event ev =
  false

let destroy () = GMain.Main.quit ()

let compbtn_click complbls caraclbls efflbl c () =
  apprend perso c;
  List.iter (fun (c, lbl) -> lbl#set_text (string_of_c c^": "^string_of_int (perso@!c)^" => "^string_of_int (efficacite perso c))) complbls;
  List.iter (fun (c, lbl) -> lbl#set_text (string_of_c c^": "^string_of_int (perso@!c))) caraclbls;
  efflbl#set_text ("Synergie globale : "^string_of_float(0.01*.(float_of_int(int_of_float(100.*.(synergie_globale perso))))))

let tentimes_click complbls caraclbls efflbl c () =
  for i = 1 to 10 do compbtn_click complbls caraclbls efflbl c () done

let main () =
  let window = GWindow.window ~border_width:10 () in
  ignore (window#event#connect#delete ~callback:delete_event);
  ignore (window#connect#destroy ~callback:destroy);
  (* packs *)
  let globalbox = GPack.vbox ~packing:window#add ~spacing:10 () in
  let mainbox = GPack.hbox ~packing:globalbox#add ~spacing:10 () in
  let infobox = GPack.hbox ~packing:globalbox#add ~spacing:10 () in
  let compbtnsbox = GPack.vbox ~packing:mainbox#add () in
  let tentimesbox = GPack.vbox ~packing:mainbox#add () in
  let compsbox = GPack.vbox ~packing:mainbox#add () in
  let caracsbox = GPack.vbox ~packing:mainbox#add () in
  (* compétences (valeurs) *)
  let complbls = List.map (fun c -> c,
    GMisc.label ~text:(string_of_c c) ~packing:compsbox#add ()) comps in
  let efflbl = GMisc.label ~text:"Synergie globale" ~packing:infobox#add () in
  (* caractéristiques (valeurs) *)
  let caraclbls = List.map (fun c -> c,
    GMisc.label ~text:(string_of_c c) ~packing:caracsbox#add ()) caracs in
  (* compétences (boutons) *)
  let compbtn_click = compbtn_click complbls caraclbls efflbl in
  let tentimes_click = tentimes_click complbls caraclbls efflbl in
  List.iter (fun c ->
    let button = GButton.button ~label:(string_of_c c) ~packing:compbtnsbox#add () in
    ignore (button#connect#clicked ~callback:(compbtn_click c))) comps;
  List.iter (fun c ->
    let button = GButton.button ~label:"x10" ~packing:tentimesbox#add () in
    ignore (button#connect#clicked ~callback:(tentimes_click c))) comps;

  window#show ();
  GMain.Main.main ()

let _ = main ()
